/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.jira.ui.handlers;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.IOUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.jira.core.JiraCorePlugin;
import com.aptana.jira.core.JiraException;
import com.aptana.jira.core.JiraIssue;
import com.aptana.jira.core.JiraIssueConfig;
import com.aptana.jira.core.JiraIssueSeverity;
import com.aptana.jira.core.JiraIssueType;
import com.aptana.jira.core.JiraManager;
import com.aptana.jira.ui.handlers.Messages;
import com.aptana.jira.ui.internal.SubmitTicketDialog;
import com.aptana.ui.commands.DiagnosticHandler;
import com.aptana.ui.dialogs.HyperlinkMessageDialog;
import com.aptana.ui.util.UIUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class SubmitTicketHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        SubmitTicketDialog dialog = new SubmitTicketDialog(UIUtils.getActiveShell());
        if (dialog.open() == 0) {
            final JiraIssueType type = dialog.getType();
            final JiraIssueSeverity severity = dialog.getSeverity();
            final String summary = dialog.getSummary();
            final String description = dialog.getDescription();
            final boolean studioLogSelected = dialog.getStudioLogSelected();
            final boolean diagnosticLogSelected = dialog.getDiagnosticLogSelected();
            final Set<IPath> screenshots = dialog.getScreenshots();
            Job job = new Job(StringUtil.ellipsify((String)Messages.SubmitTicketHandler_JobTitle)){

                protected IStatus run(IProgressMonitor monitor) {
                    JiraManager manager = SubmitTicketHandler.this.getJiraManager();
                    JiraIssue issue = null;
                    try {
                        JiraIssueConfig jiraConfig = new JiraIssueConfig();
                        jiraConfig.type = type;
                        jiraConfig.severity = severity;
                        jiraConfig.summary = summary;
                        jiraConfig.description = description.replaceAll("(\r\n|\n)", "\n");
                        issue = manager.createIssue(jiraConfig);
                    }
                    catch (JiraException e) {
                        UIUtils.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                MessageDialog.openError((Shell)UIUtils.getActiveWorkbenchWindow().getShell(), (String)Messages.SubmitTicketHandler_ERR_CreateFailed, (String)e.getMessage());
                            }
                        });
                    }
                    catch (IOException e) {
                        UIUtils.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                MessageDialog.openError((Shell)UIUtils.getActiveWorkbenchWindow().getShell(), (String)Messages.SubmitTicketHandler_ERR_CreateFailed, (String)e.getMessage());
                            }
                        });
                    }
                    if (issue != null) {
                        try {
                            String logFile;
                            File file;
                            if (studioLogSelected && (file = new File(logFile = System.getProperty("osgi.logfile"))).exists()) {
                                manager.addAttachment(Path.fromOSString((String)file.getAbsolutePath()), issue);
                            }
                            if (diagnosticLogSelected) {
                                String logContent = DiagnosticHandler.getLogContent();
                                try {
                                    file = File.createTempFile("diagnostic", ".log");
                                    file.deleteOnExit();
                                    IOUtil.write((OutputStream)new FileOutputStream(file), (String)logContent);
                                    manager.addAttachment(Path.fromOSString((String)file.getAbsolutePath()), issue);
                                }
                                catch (IOException e) {
                                    IdeLog.logWarning((Plugin)JiraCorePlugin.getDefault(), (Throwable)e);
                                }
                            }
                            for (IPath screenshot : screenshots) {
                                manager.addAttachment(screenshot, issue);
                            }
                        }
                        catch (JiraException e) {
                            IdeLog.logWarning((Plugin)JiraCorePlugin.getDefault(), (Throwable)e);
                        }
                        SubmitTicketHandler.showSuccess(issue);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        return null;
    }

    protected JiraManager getJiraManager() {
        return JiraCorePlugin.getDefault().getJiraManager();
    }

    private static void showSuccess(final JiraIssue issue) {
        UIUtils.getDisplay().asyncExec(new Runnable(){

            public void run() {
                HyperlinkMessageDialog.openInformation((Shell)UIUtils.getActiveWorkbenchWindow().getShell(), (String)Messages.SubmitTicketHandler_Success_Title, (String)MessageFormat.format(Messages.SubmitTicketHandler_Success_Message, issue.getUrl()));
            }
        });
    }
}

